
public class PreCombinedImage
{
	int[][] rawImage;

	public PreCombinedImage(int[][] rawImage)
	{
		this.rawImage = rawImage;
	}

	public int[] combineImage(boolean red, boolean green, boolean blue)
	{   // final image array = to length of the single array contained in image
		int[] finalImage = new int[rawImage[0].length];

		if(red && green && blue) // if all colors are turned on
		{
			for(int i = 0; i < rawImage[0].length-1; i++)
			{	//               ALPHA = 255   red      green   blue
				finalImage[i] = ((0xff<<24) | (rawImage[0][i]<<16) | (rawImage[1][i]<<8) | rawImage[2][i]);
			}
		}
		else // some or all colors turned off, don't put those colors in the final image
		{
			for(int i = 0; i < rawImage[0].length-1; i++)
			{
				finalImage[i] = (0xff<<24); // alpha value

				if(red)
				{
					finalImage[i] = ( finalImage[i] | ( rawImage[0][i]<<16 ) );
				}
				if(green)
				{
					finalImage[i] = ( finalImage[i] | (rawImage[1][i]<<8)  );
				}
				if(blue)
				{
					finalImage[i] = ( finalImage[i] | rawImage[2][i] );
				}
			}
		}

		return finalImage;
	}
}